
.def Temp  = r16
.def Temp2  = r17
.def Temp3  = r18





;Definition der Steuerleitungen
.equ		A0	= PB0		
.equ		E1 	= PB1		
.equ		E2	= PB2	
.equ		LCD_cntr = PORTB	;PORTB ist Kontroll-Port
.equ		LCD_DDR_cntr = DDRB
.equ		LCD_data = PORTA	
.equ		LCD_DDR_data = DDRA



;LCD Befehle
.equ		LCD_ON		= 0b10101111
.equ		LCD_OFF		= 0b10101110
.equ		LCD_RESET	= 0b11100010
.equ		LCD_START	= 0b11000000	;+ Display Start Adresse (0-31)
.equ		LCD_PAGE	= 0b10111000	;+ Display Page (0-3)
.equ 		LCD_SET_ADR = 0b00000000	;+ Display Column Adresse (0-79)
.equ		LCD_ADC		= 0b10100000
	.equ 	LCD_ADC_CW	= 0
	.equ	LCD_ADC_CCW	= 1
.equ		LCD_STATIC	= 0b10100100	; +0/1
.equ 		LCD_DUTY	= 0b10101000	;	1=1/32 0=1/16
.equ		LCD_INC		= 0b11100000
.equ		LCD_END		= 0b11101110

;Speicheradressen
.equ		LCD_Zeile1	= 0x0100
.equ		LCD_Zeile2	= 0x017A
.equ		LCD_Zeile3	= 0x01F4
.equ		LCD_Zeile4	= 0x026E
.equ		LCD_NachBuffer	= 0x02E8


LCD_Delay:
	push Temp
	push Temp2
	push Temp3
	clr Temp
	clr Temp2
	ldi Temp3,100
	dec Temp
	brne PC-1
	dec Temp2
	brne PC-3
	dec Temp3
	brne PC-5

	pop Temp3
	pop Temp2
	pop Temp
ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCDctrlout															;
;Funktion:		Gibt einen Steuerbefehl an beide Displayhlften aus					;
;Input:			Temp		-> Befehl												;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCDctrlout:
	cbi LCD_cntr,A0
	out	LCD_data,Temp

	cbi	LCD_cntr,E1	
	cbi	LCD_cntr,E2	
	sbi	LCD_cntr,E1
	sbi	LCD_cntr,E2
ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCDdata1out															;
;Funktion:		Gibt Daten an die linke Displayhlfte aus							;
;Input:			Temp		-> Daten												;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCDdata1out:
	sbi	LCD_cntr,A0
	out	LCD_data,Temp
	cbi	LCD_cntr,E1
	sbi	LCD_cntr,E1
ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCDdata2out															;
;Funktion:		Gibt Daten an die rechte Displayhlfte aus							;
;Input:			Temp		-> Daten												;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCDdata2out:
	sbi	LCD_cntr,A0
	out	LCD_data,Temp
	cbi	LCD_cntr,E2
	sbi	LCD_cntr,E2
ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCD_Startup															;
;Funktion:		Fhrt alle Funktionen aus, die ntig sind, damit das Display luft	;
;Input:			kein																;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCD_Startup:
	push Temp
	rcall LCD_Portinit

	ldi temp,LCD_RESET
	rcall LCDctrlout

	ldi temp,LCD_SET_ADR 
	rcall LCDctrlout

	ldi temp,LCD_ADC+LCD_ADC_CW
	rcall LCDctrlout

	ldi temp,LCD_DUTY +1
	rcall LCDctrlout

	ldi temp,LCD_END
	rcall LCDctrlout

	ldi temp,LCD_ON
	rcall LCDctrlout

	rcall LCD_Clear
	pop Temp
ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCD_Portinit														;
;Funktion:		Initialisiert die Ports und die Pins								;
;				an denen das Display angeschlossen ist								;
;Input:			kein																;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCD_Portinit:	
	push Temp
	ser Temp
	out LCD_DDR_data,Temp
	sbi LCD_DDR_cntr,E1
	sbi LCD_DDR_cntr,E2
	sbi LCD_DDR_cntr,A0
	sbi	LCD_cntr,E1		
	sbi	LCD_cntr,E2
	cbi	LCD_cntr,A0
	pop Temp
ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCD_Ausgeben														;
;Funktion:		Gibt den gesammten Bildpuffer auf das Display aus					;
;Input:			kein																;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCD_Ausgeben:
	push Temp
	push Temp2

	ldi temp,LCD_PAGE + 0	;Zeile 1 des LCD
	rcall LCDctrlout
	ldi temp,LCD_SET_ADR 	;erstes Zeichen
	rcall LCDctrlout
	ldi XH,HIGH(LCD_Zeile2)	;Zeile 1 im SRAM
	ldi XL,LOW(LCD_Zeile2)	;(es wird Rckwrts gezhlt!)

	ldi Temp2,61			;Counter

	ld Temp,-X				;Zeile 1 Rechts ausgeben
	rcall LCDdata2out	
	dec Temp2
	brne PC-3

	ldi Temp2,61			;Counter

	ld Temp,-X				;Zeile 1 Links ausgeben
	rcall LCDdata1out
	dec Temp2
	brne PC-3

	ldi temp,LCD_PAGE + 1
	rcall LCDctrlout
	ldi temp,LCD_SET_ADR 
	rcall LCDctrlout
	ldi XH,HIGH(LCD_Zeile3)
	ldi XL,LOW(LCD_Zeile3)

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 2 Rechts
	rcall LCDdata2out
	dec Temp2
	brne PC-3

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 2 Links
	rcall LCDdata1out
	dec Temp2
	brne PC-3

	ldi temp,LCD_PAGE + 2
	rcall LCDctrlout
	ldi temp,LCD_SET_ADR 
	rcall LCDctrlout
	ldi XH,HIGH(LCD_Zeile4)
	ldi XL,LOW(LCD_Zeile4)

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 3 Rechts
	rcall LCDdata2out
	dec Temp2
	brne PC-3

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 3 Links
	rcall LCDdata1out
	dec Temp2
	brne PC-3

	ldi temp,LCD_PAGE + 3
	rcall LCDctrlout
	ldi temp,LCD_SET_ADR 
	rcall LCDctrlout
	ldi XH,HIGH(LCD_NachBuffer)
	ldi XL,LOW(LCD_NachBuffer)

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 4 Rechts
	rcall LCDdata2out
	dec Temp2
	brne PC-3

	ldi Temp2,61		;Counter

	ld Temp,-X			;Zeile 4 Links
	rcall LCDdata1out
	dec Temp2
	brne PC-3

	pop Temp2
	pop Temp
ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;				LCD_Clear															;
;Funktion:		Lscht den Bildpuffer und gibt ihn aus								;
;Input:			kein																;
;Output:		kein																;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LCD_Clear:
	push Temp
	push Temp2
	clr Temp2	

	ldi ZH,HIGH(LCD_Zeile1)
	ldi ZL,LOW(LCD_Zeile1)
	ldi Temp,122		;Counter

	st Z+,Temp2
	dec Temp
	brne PC-2

	ldi ZH,HIGH(LCD_Zeile2)
	ldi ZL,LOW(LCD_Zeile2)
	ldi Temp,122		;Counter

	st Z+,Temp2
	dec Temp
	brne PC-2

	ldi ZH,HIGH(LCD_Zeile3)
	ldi ZL,LOW(LCD_Zeile3)
	ldi Temp,122		;Counter

	st Z+,Temp2
	dec Temp
	brne PC-2

	ldi ZH,HIGH(LCD_Zeile4)
	ldi ZL,LOW(LCD_Zeile4)
	ldi Temp,122		;Counter

	st Z+,Temp2
	dec Temp
	brne PC-2

	pop Temp2
	pop Temp

	rcall LCD_Ausgeben
ret

LCD_vom_EEPROM:
	push Temp
	push Temp2
	push r19
	push r20
	push r21
;	clr Temp	
	clr r20
	clr r19

	ldi ZH,HIGH(LCD_Zeile1)
	ldi ZL,LOW(LCD_Zeile1)
	ldi Temp2,122		;Counter

	rcall EEPROM_read
	st Z+,Temp
	ldi r21,1
	clr Temp
	add r19,r21
	adc r20,Temp
	dec Temp2
	brne PC-7


	ldi ZH,HIGH(LCD_Zeile2)
	ldi ZL,LOW(LCD_Zeile2)
	ldi Temp2,122		;Counter

	rcall EEPROM_read
	st Z+,Temp
	ldi r21,1
	clr Temp
	add r19,r21
	adc r20,Temp
	dec Temp2
	brne PC-7

	ldi ZH,HIGH(LCD_Zeile3)
	ldi ZL,LOW(LCD_Zeile3)
	ldi Temp2,122		;Counter

	rcall EEPROM_read
	st Z+,Temp
	ldi r21,1
	clr Temp
	add r19,r21
	adc r20,Temp
	dec Temp2
	brne PC-7


	ldi ZH,HIGH(LCD_Zeile4)
	ldi ZL,LOW(LCD_Zeile4)
	ldi Temp2,122		;Counter

	rcall EEPROM_read
	st Z+,Temp
	ldi r21,1
	clr Temp
	add r19,r21
	adc r20,Temp
	dec Temp2
	brne PC-7

	pop r21
	pop r20
	pop r19
	pop Temp2
	pop Temp


	rcall LCD_Ausgeben
ret

EEPROM_write:
	; Wait for completion of previous write
	sbic EECR,EEWE
	rjmp EEPROM_write
	; Set up address (r18:r17) in address register
	out EEARH, r20
	out EEARL, r19
	; Write data (r16) to data register
	out EEDR,r16
	; Write logical one to EEMWE
	sbi EECR,EEMWE
	; Start eeprom write by setting EEWE
	sbi EECR,EEWE
ret

EEPROM_read:
	; Wait for completion of previous write
	sbic EECR,EEWE
	rjmp EEPROM_read
	; Set up address (r18:r17) in address register
	out EEARH, r20
	out EEARL, r19
	; Start eeprom read by writing EERE
	sbi EECR,EERE
	; Read data from data register
	in r16,EEDR
ret