
.include "m16def.inc"

.def temp					= r16
.def temp1					= r17
.def temp2					= r18
.def Mode 					= r19
.def Counter				= r20  ;Mode2,3,4,5,6,7=Periodenposition
.def Flags					= r21
	.equ SDown				= 0
	.equ SLock				= 1
.def Counter2				= r22 ;Mode7=Speed

.DSEG
	r_FehlerZeit:	.byte 1
	r_PotiZeit:		.byte 1
	r_PWM:			.byte 1
	r_M2_DauerH:	.byte 1
	r_M2_DauerL:	.byte 1
	r_M2_PW:		.byte 1
	r_Rot_PW:		.byte 1
	r_Grun_PW:		.byte 1
	r_Blau_PW:		.byte 1
	r_FarbeH:		.byte 1
	r_FarbeL:		.byte 1
	r_Speed:		.byte 1
	r_M8_Pos:		.byte 1
.CSEG

.ORG 0x00
	rjmp reset
.ORG OC2addr
	rjmp OC2int
.ORG OC1Aaddr
	rjmp OC1Aint
Reset:
	;initialisieren des Stack-pointers
	ldi temp,HIGH(RAMEND)
	out SPH,temp
	ldi temp,LOW(RAMEND)
	out SPL,temp

	sbi DDRB,PB3		;Powerled
	cbi PORTB,PB3

	sbi DDRD,PD2		;Blau
	cbi PORTD,PD2	
	sbi DDRD,PD3		;Grn
	cbi PORTD,PD3
	sbi DDRD,PD4		;Rot
	cbi PORTD,PD4

	cbi DDRD,PD5		;B
	sbi PORTD,PD5
	cbi DDRD,PD6		;A
	sbi PORTD,PD6
	cbi DDRD,PD7		;S
	sbi PORTD,PD7


	ldi temp,(1<<CS22)|(1<<WGM21)
	out TCCR2,temp
	ldi temp,100
	out OCR2,temp
	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	clr Flags

	ldi temp,2
	sts r_PWM,temp
	ldi temp,0
	sts r_M2_DauerL,temp
	ldi temp,10
	sts r_M2_DauerH,temp
	ldi temp,10
	sts r_M2_PW,temp

	ldi temp,50
	sts r_Rot_PW,temp
	ldi temp,50
	sts r_Grun_PW,temp
	ldi temp,50
	sts r_Blau_PW,temp

	ldi temp,1
	sts r_FarbeH,temp
	ldi temp,127
	sts r_FarbeL,temp

	ldi temp,73
	sts r_Speed,temp


	call initMode1
	
	sei
rjmp Main
///////////////////////////


OC2int:	;wird alle 0,8ms Ausgefhrt
	push temp
	in temp,SREG
	push temp
	push temp1
	push temp2

	cpi Mode,8
	brne OC2intC

	dec counter2
	brne OC2intC
LadeSeqWert:
	lpm temp,Z+
	lpm Counter2,Z+
	cpi temp,255
	brne SeqWertgeladen	
		ldi ZL,LOW(Flasher*2)
		ldi ZH,HIGH(Flasher*2)
		rjmp LadeSeqWert
SeqWertgeladen:
	sbrc temp,0
		sbi PORTD,PD4
	sbrs temp,0
		cbi PORTD,PD4
	sbrc temp,1
		sbi PORTD,PD3
	sbrs temp,1
		cbi PORTD,PD3
	sbrc temp,2
		sbi PORTD,PD2
	sbrs temp,2
		cbi PORTD,PD2



OC2intC: ;Mode7 Scrolling
	cpi Mode,7
	brne OC2intB
	dec Counter2
	brne OC2intB
		lds counter2,r_Speed
		subi counter2,70
		cpi counter2,0
		breq HighStep
		cpi counter2,186
		brsh HighStep
		;OneStep
		ldi temp2,1						;Step
		rjmp Step
HighStep:
		dec Counter2 ;jetz 185-255
		ldi temp2,255
		sub temp2,Counter2 ;jetz 0-70
		inc temp2
		inc temp2 ;jetz Step 2-72
		ldi Counter2,1



Step:
		lds temp,r_FarbeH
		lds temp1,r_FarbeL
		add temp1,temp2
		clr temp2
		adc temp,temp2
		sts r_FarbeH,temp
		sts r_FarbeL,temp1
		call RGBermitteln


OC2intB:		;FehlerZeit und Potispeed ermitteln (0,8ms Basis)
	lds temp,r_PotiZeit
	cpi temp,255
	breq PC+4
		inc temp
		sts r_PotiZeit,temp


	lds temp,r_FehlerZeit
	cpi temp,0
	brne PC+2
		rjmp LeaveOC2int
	dec temp
	sts r_FehlerZeit,temp
	brne LeaveOC2int

	cbi PORTD,PD2
	cbi PORTD,PD3
	cbi PORTD,PD4
	cbi PORTB,PD3


	LeaveOC2int:
	pop temp2
	pop temp1
	pop temp
	out SREG,temp
	pop temp
reti

////////////////////////

OC1Aint:
push temp
in temp,SREG
push temp

	cpi Mode,2
	brne OC1AintM3
	inc Counter
	cpi Counter,0
	brne PC+2
		sbi PORTB,PB3

	lds temp,r_M2_PW
	cp Counter,temp
	brlo PC+2
		cbi PORTB,PB3


pop temp
out SREG,temp
pop temp
reti

OC1AintM3:		;Dimmer PWMs
push temp1
	inc Counter
	in temp1,PORTD
	cpi Counter,0
	brne PC+2
		ldi temp1,0b11111100 ;Lampen an bei NULL



	lds temp,r_Rot_PW
	cp Counter,temp
	brlo PC+2
		cbr temp1,1<<4

	lds temp,r_Grun_PW
	cp Counter,temp
	brlo PC+2
		cbr temp1,1<<3

	lds temp,r_Blau_PW
	cp Counter,temp
	brlo PC+2
		cbr temp1,1<<2

	cpi Counter,254
	brne PC+2
		ldi Counter,255


	out PORTD,temp1


pop temp1
pop temp
out SREG,temp
pop temp
reti
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////	
Main:


call Potipruefen

rjmp Main
///////////////////////////////////POTI
Potipruefen:
	in temp,PIND
	andi temp,0b10000000
	cpi temp,0b00000000
	brne PC+5
		;wenn S gedrckt wird
		sbrs Flags,SDown
		rcall entprellen2
		sbr Flags,(1<<SDown)	
		rjmp PotipruefenSFlankeFin
	;wenn nicht gedrckt wird
	sbrc Flags,SLock
		rjmp PotipruefenSFlankeReset
	sbrs Flags,SDown
		rjmp PotipruefenSFlankeReset
	;Flanke erkannt
	cbr Flags,(1<<SDown)|(1<<SLock)
	call entprellen2
	jmp PotiTaster
PotipruefenSFlankeReset:
	cbr Flags,(1<<SDown)|(1<<SLock)
PotipruefenSFlankeFin:
	in temp,PIND
	andi temp,0b01100000
	cpi temp,0b00000000
	breq PC+2
		ret
	;Mittelstellung erkannt
	call entprellen1
	PotipruefenLoop:
	in temp,PIND
	andi temp,0b01100000
	cpi temp,0b00000000
	breq PotipruefenLoop
	call entprellen1
	sbrs temp,6
		rjmp PotiPlus
	sbrs temp,5
		rjmp PotiMinus



	Call FehlerGrun

ret
PotiTaster:
	ldi ZL,LOW(ST_PotiTaster)
	ldi ZH,HIGH(ST_PotiTaster)
	
	add ZL,Mode
	clr temp
	adc ZH,temp

	add ZL,Mode
	clr temp
	adc ZH,temp
	ijmp
ret
ST_PotiTaster:
nop
nop
jmp InitMode2	;1
jmp InitMode7	;2
jmp InitMode8	;3
jmp InitMode8	;4
jmp InitMode8	;5
jmp InitMode3	;6
jmp InitMode6	;7
jmp InitMode9	;8






PotiPlus:
	lds temp,r_PotiZeit
	clr temp1
	sts r_PotiZeit,temp1
	cpi temp,5
	brsh PC+4
		ldi ZL,LOW(ST_PotiPlusSchnell)
		ldi ZH,HIGH(ST_PotiPlusSchnell)
		rjmp PC+3
	ldi ZL,LOW(ST_PotiPlus)
	ldi ZH,HIGH(ST_PotiPlus)

	sbic PIND,PIND7
		rjmp PotiPlusOT
	;Mit Taster
	sbr Flags,(1<<SDown)|(1<<SLock)
	ldi ZL,LOW(ST_PotiPlusMT)
	ldi ZH,HIGH(ST_PotiPlusMT)


	PotiPlusOT:
	add ZL,Mode
	clr temp
	adc ZH,temp
	add ZL,Mode
	clr temp
	adc ZH,temp
	ijmp
ret

ST_PotiPlus:
nop				;Mode0
nop
jmp Mode1Plus
jmp Mode2Plus
jmp Mode3Plus
jmp Mode4Plus
jmp Mode5Plus
jmp Mode6Plus
jmp Mode7Plus
jmp Mode8Plus







ST_PotiPlusSchnell:
nop				;Mode0
nop
jmp Mode1PlusSchnell
jmp Mode2PlusSchnell
jmp Mode3PlusSchnell
jmp Mode4PlusSchnell
jmp Mode5PlusSchnell
jmp Mode6PlusSchnell
jmp Mode7Plus
jmp Mode8PlusSchnell



ST_PotiPlusMT:
nop				;Mode0
nop
jmp Mode1PlusMT
jmp Mode2PlusMT
jmp initMode4
jmp initMode5
jmp initMode3
jmp Mode6PlusMT
jmp Mode7PlusMT
jmp Mode8PlusMT







PotiMinus:
	lds temp,r_PotiZeit
	clr temp1
	sts r_PotiZeit,temp1
	cpi temp,5
	brsh PC+6
		call FehlerBlau
		ldi ZL,LOW(ST_PotiMinusSchnell)
		ldi ZH,HIGH(ST_PotiMinusSchnell)
		rjmp PC+3
	ldi ZL,LOW(ST_PotiMinus)
	ldi ZH,HIGH(ST_PotiMinus)
	
	sbic PIND,PIND7
		rjmp PotiMinusOT
	;Mit Taster
	sbr Flags,(1<<SDown)|(1<<SLock)
	ldi ZL,LOW(ST_PotiMinusMT)
	ldi ZH,HIGH(ST_PotiMinusMT)


	PotiMinusOT:

	add ZL,Mode
	clr temp
	adc ZH,temp
	add ZL,Mode
	clr temp
	adc ZH,temp
	ijmp
ret
ST_PotiMinus:
nop				;Mode0
nop
jmp Mode1Minus
jmp Mode2Minus
jmp Mode3Minus
jmp Mode4Minus
jmp Mode5Minus
jmp Mode6Minus
jmp Mode7Minus
jmp Mode8Minus







ST_PotiMinusSchnell:
nop				;Mode0
nop
jmp Mode1MinusSchnell
jmp Mode2MinusSchnell
jmp Mode3MinusSchnell
jmp Mode4MinusSchnell
jmp Mode5MinusSchnell
jmp Mode6MinusSchnell
jmp Mode7Minus
jmp Mode8MinusSchnell




ST_PotiMinusMT:
nop				;Mode0
nop
jmp Mode1MinusMT
jmp Mode2MinusMT
jmp initMode5
jmp initMode3
jmp initMode4
jmp Mode6MinusMT
jmp Mode7MinusMT
jmp Mode8MinusMT





////////////////////////////////////////////////////////////////////////

Mode1Plus:
	lds temp,r_PWM
	cpi temp,255
	brne PC+4
		call FehlerRot
		ret
	inc temp
	sts r_PWM,temp
	out OCR0,temp
ret
Mode1PlusSchnell:
	call FehlerBlau
	lds temp,r_PWM
	cpi temp,255-10
	brlo PC+4
		call FehlerRot
		ldi temp,255-10
	ldi temp1,10
	add temp,temp1
	sts r_PWM,temp
	out OCR0,temp
ret
Mode1PlusMT:
	ser temp
	sts r_PWM,temp
	out OCR0,temp
ret
Mode1Minus:
	lds temp,r_PWM
	cpi temp,0
	brne PC+4
		call FehlerRot
		ret
	dec temp
	sts r_PWM,temp
	out OCR0,temp
ret
Mode1MinusSchnell:
	call FehlerBlau
	lds temp,r_PWM
	cpi temp,10
	brsh PC+4
		call FehlerRot
		ldi temp,10
	ldi temp1,10
	sub temp,temp1
	sts r_PWM,temp
	out OCR0,temp
ret
Mode1MinusMT:
	clr temp
	sts r_PWM,temp
	out OCR0,temp
ret
////////////////////////////////////////////////////////77
Mode2Plus:
	lds temp1,r_M2_DauerH
	lds temp2,r_M2_DauerL
	cpi temp1,255
	brlo PC+6
	cpi temp2,255
	brlo PC+4
		call FehlerRot
		ret

	ldi temp,1
	add temp2,temp
	clr temp
	adc temp1,temp

	sts r_M2_DauerH,temp1
	sts r_M2_DauerL,temp2
	out OCR1AH,temp1
	out OCR1AL,temp2
ret
Mode2PlusMT:
	lds temp,r_M2_PW
	cpi temp,254
	brne PC+4
		call FehlerRot
		ret
	inc temp
	sts r_M2_PW,temp
ret
Mode2PlusSchnell:
	call FehlerBlau
	lds temp1,r_M2_DauerH
	lds temp2,r_M2_DauerL
	ldi temp,50
	add temp2,temp
	clr temp
	adc temp1,temp
	cpi temp1,0
	brne PC+5
		ser temp1
		ser temp2
		call FehlerRot

	sts r_M2_DauerH,temp1
	sts r_M2_DauerL,temp2
	out OCR1AH,temp1
	out OCR1AL,temp2
ret
Mode2Minus:
	lds temp1,r_M2_DauerH
	lds temp2,r_M2_DauerL
	ldi temp,1
	sub temp2,temp
	clr temp
	sbc temp1,temp
	
	cpi temp1,0
	brne Mode2MinusFin
	cpi temp2,60
	brsh Mode2MinusFin
		ldi temp2,60
		call FehlerRot

Mode2MinusFin:
	sts r_M2_DauerH,temp1
	sts r_M2_DauerL,temp2
	out OCR1AH,temp1
	out OCR1AL,temp2
ret
Mode2MinusMT:
	lds temp,r_M2_PW
	cpi temp,1
	brne PC+4
		call FehlerRot
		ret
	dec temp
	sts r_M2_PW,temp
ret
Mode2MinusSchnell:
	call FehlerBlau
	lds temp1,r_M2_DauerH
	lds temp2,r_M2_DauerL
	ldi temp,50
	sub temp2,temp
	clr temp
	sbc temp1,temp
	
	cpi temp1,0
	brne Mode2MinusSchnellFin
	cpi temp2,60
	brsh Mode2MinusSchnellFin
		ldi temp2,60
		call FehlerRot

Mode2MinusSchnellFin:
	sts r_M2_DauerH,temp1
	sts r_M2_DauerL,temp2
	out OCR1AH,temp1
	out OCR1AL,temp2
ret
/////////////////////////////    3
;MT = andere Farbe
Mode3Plus:
	lds temp,r_Rot_PW
	cpi temp,255
	brne PC+4
		call Fehlerweiss
		ret
	inc temp
	sts r_Rot_PW,temp
ret
Mode3PlusSchnell:
	lds temp,r_Rot_PW
	ldi temp1,10
	add temp,temp1
	cpi temp,10
	brsh PC+4
		call Fehlerweiss
		ldi temp,255
	sts r_Rot_PW,temp
ret

Mode3Minus:
	lds temp,r_Rot_PW
	cpi temp,0
	brne PC+4
		call Fehlerweiss
		ret
	dec temp
	sts r_Rot_PW,temp
ret
Mode3MinusSchnell:
	lds temp,r_Rot_PW
	ldi temp1,10
	sub temp,temp1
	cpi temp,246
	brlo PC+4
		call Fehlerweiss
		ldi temp,0
	sts r_Rot_PW,temp
ret
/////////////////////////////////////4
Mode4Plus:
	lds temp,r_Grun_PW
	cpi temp,255
	brne PC+4
		call Fehlerweiss
		ret
	inc temp
	sts r_Grun_PW,temp
ret
Mode4PlusSchnell:
	lds temp,r_Grun_PW
	ldi temp1,10
	add temp,temp1
	cpi temp,10
	brsh PC+4
		call Fehlerweiss
		ldi temp,255
	sts r_Grun_PW,temp
ret
Mode4Minus:
	lds temp,r_Grun_PW
	cpi temp,0
	brne PC+4
		call Fehlerweiss
		ret
	dec temp
	sts r_Grun_PW,temp
ret
Mode4MinusSchnell:
	lds temp,r_Grun_PW
	ldi temp1,10
	sub temp,temp1
	cpi temp,246
	brlo PC+4
		call Fehlerweiss
		ldi temp,0
	sts r_Grun_PW,temp
ret

////////////////////////           5
Mode5Plus:
	lds temp,r_Blau_PW
	cpi temp,255
	brne PC+4
		call Fehlerweiss
		ret
	inc temp
	sts r_Blau_PW,temp
ret
Mode5PlusSchnell:
	lds temp,r_Blau_PW
	ldi temp1,10
	add temp,temp1
	cpi temp,10
	brsh PC+4
		call Fehlerweiss
		ldi temp,255
	sts r_Blau_PW,temp
ret
Mode5Minus:
	lds temp,r_Blau_PW
	cpi temp,0
	brne PC+4
		call Fehlerweiss
		ret
	dec temp
	sts r_Blau_PW,temp
ret
Mode5MinusSchnell:
	lds temp,r_Blau_PW
	ldi temp1,10
	sub temp,temp1
	cpi temp,246
	brlo PC+4
		call Fehlerweiss
		ldi temp,0
	sts r_Blau_PW,temp
ret
/////////////////////////////       6
Mode6Plus:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,1
	add temp1,temp2
	clr temp2
	adc temp,temp2
	cpi temp,6
	brlo PC+2
	ldi temp,0
	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
Mode6PlusSchnell:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,10
	add temp1,temp2
	clr temp2
	adc temp,temp2
	cpi temp,6
	brlo PC+2
	ldi temp,0
	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
Mode6PlusMT:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,1
	add temp1,temp2
	clr temp2
	adc temp,temp2
	cpi temp,6
	brlo PC+2
	ldi temp,0
	ldi temp1,255
	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
Mode6Minus:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,1
	sub temp1,temp2
	clr temp2
	sbc temp,temp2
	cpi temp,255
	brne PC+2
	ldi temp,5

	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
Mode6MinusSchnell:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,10
	sub temp1,temp2
	clr temp2
	sbc temp,temp2
	cpi temp,255
	brne PC+2
	ldi temp,5

	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
Mode6MinusMT:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL
	ldi temp2,1
	sub temp1,temp2
	clr temp2
	sbc temp,temp2
	cpi temp,255
	brne PC+2
	ldi temp,5
	ldi temp1,0

	sts r_FarbeH,temp
	sts r_FarbeL,temp1
	call RGBermitteln
ret
////////////////////////////////////  7
Mode7Plus:
	lds temp,r_Speed
	cpi temp,255
	brne PC+4
		call Fehlerweiss
		ret
	inc temp
	sts r_Speed,temp
ret
Mode7PlusMT:
	lds temp,r_Speed
	cpi temp,255
	brne PC+4
		call Fehlerweiss
		ret
	ser temp
	sts r_Speed,temp
ret
Mode7Minus:
	lds temp,r_Speed
	cpi temp,0
	brne PC+4
		call Fehlerweiss
		ret
	dec temp
	sts r_Speed,temp
ret
Mode7MinusMT:
	lds temp,r_Speed
	cpi temp,0
	brne PC+4
		call Fehlerweiss
		ret
	clr temp
	sts r_Speed,temp
ret
/////////////////////////////////////////////8
Mode8Plus:
Mode8PlusSchnell:
Mode8PlusMT:
Mode8Minus:
Mode8MinusSchnell:
Mode8MinusMT:
call FehlerWeiss
call initMode8
ret
////////////////////////////////////
FehlerRot:
		sbi PORTD,PD4
		ldi temp,5
		sts r_Fehlerzeit,temp
ret
FehlerGrun:
		sbi PORTD,PD3
		ldi temp,5
		sts r_Fehlerzeit,temp
ret
FehlerBlau:
		sbi PORTD,PD2
		ldi temp,5
		sts r_Fehlerzeit,temp
ret
FehlerWeiss:
		sbi PORTB,PB3
		ldi temp,5
		sts r_Fehlerzeit,temp
ret
entprellen1:
	push temp
	push temp1
	ldi temp,255
	ldi temp1,5
	dec temp
	brne PC-1
	dec temp1
	brne PC-3
	pop temp1
	pop temp
ret
entprellen2:
	push temp
	push temp1
	ldi temp,255
	ldi temp1,40
	dec temp
	brne PC-1
	dec temp1
	brne PC-3
	pop temp1
	pop temp
ret
warten1:
	push temp
	push temp1
	push temp2
	ldi temp,255
	clr temp1
	ldi temp2,5

	dec temp
	brne PC-1
	dec temp1
	brne PC-3
	dec temp2
	brne PC-5

	pop temp2
	pop temp1
	pop temp
ret

initMode1:
	ldi Mode,1
	cbi PORTD,PD4
	cbi PORTD,PD3
	cbi PORTD,PD2

	ldi temp,(1<<WGM00)|(1<<CS01)|(1<<WGM01)|(1<<COM01)
	out TCCR0,temp

	lds temp,r_PWM
	out OCR0,temp
ret
initMode2:
	ldi Mode,2
	clr temp
	out TCCR1A,temp
	out TCCR0,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	lds temp,r_M2_DauerH
	out OCR1AH,temp
	lds temp,r_M2_DauerL
	out OCR1AL,temp

	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp

ret
initMode3:
	ldi Mode,3
	
	cbi PORTB,PB3


	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	sbi PORTD,PD4
	cbi PORTD,PD3
	cbi PORTD,PD2
	call warten1

	clr temp
	out TCCR1A,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	ldi temp,0
	out OCR1AH,temp
	ldi temp,100
	out OCR1AL,temp


	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp
ret
initMode4:
	ldi Mode,4
	cbi PORTB,PB3

	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	cbi PORTD,PD4
	sbi PORTD,PD3
	cbi PORTD,PD2

	call warten1

	clr temp
	out TCCR1A,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	ldi temp,0
	out OCR1AH,temp
	ldi temp,100
	out OCR1AL,temp

	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp

ret
initMode5:
	ldi Mode,5
	cbi PORTB,PB3

	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	cbi PORTD,PD4
	cbi PORTD,PD3
	sbi PORTD,PD2

	call warten1

	clr temp
	out TCCR1A,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	ldi temp,0
	out OCR1AH,temp
	ldi temp,100
	out OCR1AL,temp

	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp
ret
initMode6:
	ldi Mode,6
	cbi PORTB,PB3
	clr temp
	out TCCR1A,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	ldi temp,0
	out OCR1AH,temp
	ldi temp,100
	out OCR1AL,temp

	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp
	call RGBermitteln
ret
initMode7:
	ldi Mode,7
	cbi PORTB,PB3
	clr temp
	out TCCR1A,temp
	ldi temp,(1<<WGM12)|(1<<CS10)
	out TCCR1B,temp

	ldi temp,0
	out OCR1AH,temp
	ldi temp,100
	out OCR1AL,temp

	ldi temp,(1<<OCIE1A)|(1<<OCIE2)
	out TIMSK,temp
	call RGBermitteln
ret
initMode8:
	ldi Mode,8
	clr temp
	out TCCR1B,temp
	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	ldi temp,0
	sts r_M8_Pos,temp
	
	ldi ZL,LOW(Flasher*2)
	ldi ZH,HIGH(Flasher*2)
	lpm temp,Z+
	lpm Counter2,Z+
	sbi PORTD,PD4


ret
initMode9:
	clr temp
	out TCCR1B,temp
	ldi temp,(1<<OCIE2)
	out TIMSK,temp

	call initMode1

ret



RGBermitteln:
	lds temp,r_FarbeH
	lds temp1,r_FarbeL

	cpi temp,0
	brne RGBermitteln1
	ser temp2
	sts r_Rot_PW,temp2
	sub temp2,temp1
	sts r_Blau_PW,temp2
	clr temp2
	sts r_Grun_PW,temp2
	ret
RGBermitteln1:
	cpi temp,1
	brne RGBermitteln2
	sts r_Grun_PW,temp1
	clr temp2
	sts r_Blau_PW,temp2
	ser temp2
	sts r_Rot_PW,temp2
	ret
RGBermitteln2:
	cpi temp,2
	brne RGBermitteln3
	ser temp2
	sts r_Grun_PW,temp2
	sub temp2,temp1
	sts r_Rot_PW,temp2
	clr temp2
	sts r_Blau_PW,temp2
	ret
RGBermitteln3:
	cpi temp,3
	brne RGBermitteln4
	sts r_Blau_PW,temp1
	clr temp2
	sts r_Rot_PW,temp2
	ser temp2
	sts r_Grun_PW,temp2
	ret
RGBermitteln4:
	cpi temp,4
	brne RGBermitteln5
	ser temp2
	sts r_Blau_PW,temp2
	sub temp2,temp1
	sts r_Grun_PW,temp2
	clr temp2
	sts r_Rot_PW,temp2
	ret
RGBermitteln5:
	cpi temp,5
	brne RGBermittelnNA
	sts r_Rot_PW,temp1
	clr temp2
	sts r_Grun_PW,temp2
	ser temp2
	sts r_Blau_PW,temp2
	ret
RGBermittelnNA:
	subi temp,6

	sts r_FarbeH,temp
	rjmp RGBermitteln
ret

Flasher: 	.DB 0b00000001,50, 0b00000000,50, 0b00000001,150, 0b00000000,50,0b00000001,50, 0b00000000,50
a:			.DB 0b00000100,50, 0b00000000,50, 0b00000100,150, 0b00000000,50,0b00000100,50, 0b00000000,50, 255,0
